// exportCollections.js
const mongoose = require('mongoose');
const fs = require('fs');
const path = require('path');

// MongoDB URI
const uri = "mongodb+srv://konsadbhaiye:boneisnotboneing@cluster0.rqgypbf.mongodb.net/humlie?retryWrites=true&w=majority";

console.log("⏳ Fetching data from MongoDB...");
// Connect with Mongoose
mongoose.connect(uri, {
    useNewUrlParser: true,
    useUnifiedTopology: true
})
.then(async () => {
    console.log("✅ Mongoose connected to MongoDB");

    const db = mongoose.connection.db;

    // Get all collection names
    const collections = await db.listCollections().toArray();

    for (let col of collections) {
        const colName = col.name;
        const collection = db.collection(colName);

        // Fetch all documents
        const data = await collection.find({}).toArray();

        // Write to JSON file
        const filePath = path.join(__dirname, `${colName}.json`);
        fs.writeFileSync(filePath, JSON.stringify(data, null, 2));

        console.log(`📁 Saved ${colName}.json with ${data.length} documents`);
    }

    mongoose.connection.close();
})
.catch(err => {
    console.error("❌ Error connecting to MongoDB:", err);
});
